﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.SessionFactory;
using Mdws2ORM.Maps;
using Mdws2ORM.Maps.EIS;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps.EVS;
using Mdws2ORM.Maps.WF;
using Mdws2ORM;
using Mdws2ORM.QuerySvcService;
using System.Configuration;
using BMS.VistaIntegration.Data.WF;

namespace BMS.VistaIntegration.Mdws
{
    public static class BmsSessionFactory
    {

        internal readonly static Mdws2ORM.Core.ISessionFactory SessionFactory;
        internal readonly static Mdws2ORM.Core.ISessionFactory SessionFactoryWithBedHold;

        private const string UsingNewMdwsMethodsKey = "UsingNewMdwsMethods";

        static BmsSessionFactory()
        {
            bool usingNewMdwsMethods = bool.Parse(ConfigurationManager.AppSettings[UsingNewMdwsMethodsKey]);
            if (usingNewMdwsMethods)
                SessionFactoryProvider.Instance.SetQueryMethods(QueryMethods.DDR);
            else
                SessionFactoryProvider.Instance.SetQueryMethods(QueryMethods.RunRpc);

            SessionFactory = SessionFactoryProvider.Instance.MakeSessionFactory();
            SessionFactoryWithBedHold = SessionFactoryProvider.Instance.MakeSessionFactory();
            InitEis();
            InitEvs();
            InitWf();
            SessionFactory.Initialize();
            SessionFactoryWithBedHold.Initialize();
        }

        private static void Add<T, E>()
            where T : BaseEntityMap<E>, new()
            where E : class
        {
            SessionFactory.Add<E>(new T());
            SessionFactoryWithBedHold.Add<E>(new T());
        }

        private static void InitEis()
        {
            Add<HospitalLocationMap, HospitalLocation>();
            Add<NewPersonMap, NewPerson>();
            Add<PatientMap, Patient>();
            Add<WardLocationMap,WardLocation>();
            SessionFactory.Add<RoomBed>(new RoomBedMap());
            SessionFactoryWithBedHold.Add<RoomBed>(new RoomBedWithBedHoldMap());
        }

        private static void InitEvs()
        {
            Add<FacilityMovementTypeMap, FacilityMovementType>();
            Add<FacilityTreatingSpecialtyMap, FacilityTreatingSpecialty>();
            Add<MasMovementTransactionTypeMap, MasMovementTransactionType>();
            Add<MedicalCenterDivisionMap, MedicalCenterDivision>();
            Add<OrderableItemMap, OrderableItem>();
            Add<OrderStatusMap, OrderStatus>(); 
            Add<SpecialtyMap, Specialty>(); 
        }

        private static void InitWf()
        {
            Add<PatientMovementMap, PatientMovement>();
            Add<OrderActionMap, OrderAction>();
            Add<OrderMap, Order>();
            Add<PatientAppointmentMap, PatientAppointment>(); 
            Add<BedSwitchMap, BedSwitch>();
            Add<ScheduledAdmissionMap, ScheduledAdmission>(); 
            Add<AdmittedPatientMap, AdmittedPatient>();
            Add<PatientMovementIenMap, PatientMovementIen>();
        }

        public static ISession CreateSession(QuerySvcSoap client, bool isBedHold, VistASite vistaSite)
        {
            ISession session = isBedHold ?
                SessionFactoryWithBedHold.CreateSession(client, vistaSite) :
                SessionFactory.CreateSession(client, vistaSite);
            session.ThrowExceptionWhenReferenceEntityNotFound = false;
            return session;
        }


    }
}
